/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.programs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import org.emboss.jemboss.soap.MakeFileSafe;

public class ListFile {
    public static void parse(String fn, Hashtable filesToMove) {
        String lfn = ListFile.trim(fn);
        File inFile = new File(lfn);
        if (inFile.exists() && inFile.canRead() && inFile.isFile() || fn.startsWith("internalList::")) {
            String sfs = new String("internalList");
            if (inFile.exists()) {
                MakeFileSafe sf = new MakeFileSafe(lfn);
                sfs = sf.getSafeFileName();
            }
            try {
                String line;
                BufferedReader in;
                if (fn.startsWith("internalList::")) {
                    fn = fn.substring(14);
                    in = new BufferedReader(new StringReader(fn));
                    in.readLine();
                } else {
                    in = new BufferedReader(new FileReader(inFile));
                }
                String listfile = "";
                while ((line = in.readLine()) != null) {
                    String[] arrayOfFiles = ListFile.expandWildcards(line);
                    if (arrayOfFiles != null) {
                        for (int i = 0; i < arrayOfFiles.length; ++i) {
                            listfile = ListFile.addFileToList(arrayOfFiles[i], listfile, filesToMove);
                        }
                        continue;
                    }
                    if (line.startsWith("@") || line.startsWith("list::")) {
                        lfn = ListFile.trim(line);
                        if (new File(lfn).exists()) {
                            MakeFileSafe lf = new MakeFileSafe(lfn);
                            String slf = lf.getSafeFileName();
                            if (!filesToMove.containsKey(slf)) {
                                ListFile.parse(lfn, filesToMove);
                            }
                            listfile = listfile.concat("@" + slf + "\n");
                            continue;
                        }
                        listfile = listfile.concat(line + "\n");
                        continue;
                    }
                    listfile = ListFile.addFileToList(line, listfile, filesToMove);
                }
                filesToMove.put(sfs, listfile.getBytes());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static String addFileToList(String line, String listfile, Hashtable filesToMove) {
        File pFile = new File(line);
        if (pFile.exists() && pFile.canRead() && pFile.isFile()) {
            MakeFileSafe pf = new MakeFileSafe(line);
            String spf = pf.getSafeFileName();
            if (!filesToMove.containsKey(spf)) {
                filesToMove.put(spf, ListFile.getLocalFile(pFile));
            }
            listfile = listfile.concat(spf + "\n");
        } else {
            listfile = listfile.concat(line + "\n");
        }
        return listfile;
    }

    private static byte[] getLocalFile(File name) {
        byte[] b = null;
        try {
            long s = name.length();
            b = new byte[(int)s];
            FileInputStream fi = new FileInputStream(name);
            fi.read(b);
            fi.close();
        }
        catch (IOException ioe) {
            System.out.println("Cannot read file: " + name);
        }
        return b;
    }

    private static String[] expandWildcards(String line) {
        String path;
        File pathDir;
        String fs;
        int index;
        int wildIndex = line.indexOf("*");
        if (wildIndex > -1 && (index = line.lastIndexOf(fs = System.getProperty("file.separator"))) > 0 && (pathDir = new File(path = line.substring(0, index))).exists()) {
            final String prefix = line.substring(index + 1, wildIndex);
            String suff = "";
            if (wildIndex + 1 < line.length()) {
                suff = line.substring(wildIndex + 1, line.length());
            }
            final String suffix = suff;
            String[] listFiles = pathDir.list(new FilenameFilter(){

                public boolean accept(File cwd, String name) {
                    return name.startsWith(prefix) && name.endsWith(suffix);
                }
            });
            for (int i = 0; i < listFiles.length; ++i) {
                listFiles[i] = path.concat(fs + listFiles[i]);
            }
            if (listFiles.length > 0) {
                return listFiles;
            }
        }
        return null;
    }

    private static String trim(String fn) {
        String lfn = fn.startsWith("@") ? new String(fn.substring(1)) : (fn.startsWith("list::") ? new String(fn.substring(6)) : fn);
        return lfn;
    }
}

