/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.io.FastaFile;

public class AMSAFile
extends FastaFile {
    AlignmentI al;

    public AMSAFile(AlignmentI al) {
        this.al = al;
    }

    public String print() {
        super.print(this.getSeqsAsArray());
        if (this.al.getAlignmentAnnotation() != null) {
            for (int i = 0; i < this.al.getAlignmentAnnotation().length; ++i) {
                AlignmentAnnotation aa = this.al.getAlignmentAnnotation()[i];
                if (aa.autoCalculated || !aa.visible) continue;
                this.out.append(">#_" + aa.label);
                if (aa.description != null) {
                    this.out.append(" " + aa.description);
                }
                this.out.append("\n");
                int nochunks = Math.min(aa.annotations.length, this.al.getWidth()) / this.len + 1;
                for (int j = 0; j < nochunks; ++j) {
                    int start = j * this.len;
                    int end = start + this.len;
                    if (end > aa.annotations.length) {
                        end = aa.annotations.length;
                    }
                    for (int k = start; k < end; ++k) {
                        String ch = aa.annotations[k] == null ? " " : aa.annotations[k].displayCharacter;
                        this.out.append(ch);
                    }
                    this.out.append("\n");
                }
            }
        }
        return this.out.toString();
    }
}

