/* Test mpz_sizeinbase.

Copyright 2001 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MP Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#include <stdio.h>
#include <stdlib.h>
#include "gmp.h"
#include "gmp-impl.h"
#include "tests.h"


/* Create a fake mpz consisting of just a single 1 bit, with totbits being
   the total number of bits, inclusive of that 1 bit.  */
void
mpz_fake_bits (mpz_ptr z, unsigned long totbits)
{
  static mp_limb_t  n;
  unsigned long     zero_bits, zero_limbs;

  zero_bits = totbits - 1;
  zero_limbs = zero_bits / BITS_PER_MP_LIMB;
  zero_bits %= BITS_PER_MP_LIMB;

  SIZ(z) = zero_limbs + 1;
  PTR(z) = (&n) - (SIZ(z) - 1);
  n = CNST_LIMB(1) << zero_bits;

  ASSERT_ALWAYS (mpz_sizeinbase (z, 2) == totbits);
}


/* This was seen to fail on a GNU/Linux powerpc32 with gcc 2.95.2,
   apparently due to a doubtful value of mp_bases[10].chars_per_bit_exactly
   (0X1.34413509F79FDP-2 whereas 0X1.34413509F79FFP-2 is believed correct).
   Presumably this is a glibc problem when gcc converts the decimal string
   in mp_bases.c, or maybe it's only a function of the rounding mode during
   compilation.  */
void
check_sample (void)
{
  unsigned long  totbits = 198096465;
  int        base = 10;
  size_t     want = 59632979;
  size_t     got;
  mpz_t      z;

  mpz_fake_bits (z, totbits);
  got = mpz_sizeinbase (z, base);
  if (got != want)
    {
      printf ("mpz_sizeinbase\n");
      printf ("  base    %d\n",  base);
      printf ("  totbits %lu\n", totbits);
      printf ("  got     %u\n",  got);
      printf ("  want    %u\n",  want);
      abort ();
    }
}


int
main (void)
{
  tests_start ();

  check_sample ();

  tests_end ();
  exit (0);
}
