
/*-------------------------------------------------------------*/
/***************************************************************
 * Functions herein permit to change global configuration of   *
 * netwib.                                                     *
 ***************************************************************/

/*-------------------------------------------------------------*/
/* See below for the meaning of those values */
typedef enum {
  NETWIB_GLOBAL_CTLTYPE_ERR_PURGE = 1,
  NETWIB_GLOBAL_CTLTYPE_CONF_UPDATE
} netwib_global_ctltype;
netwib_err netwib_global_ctl_set(netwib_global_ctltype type,
                                 netwib_ptr p,
                                 netwib_uint32 ui);
netwib_err netwib_global_ctl_get(netwib_global_ctltype type,
                                 netwib_ptr p,
                                 netwib_uint32 *pui);

/*-------------------------------------------------------------*/
/* purge last error */
/* netwib_err f(void); */
#define netwib_global_ctl_set_err_purge() netwib_global_ctl_set(NETWIB_GLOBAL_CTLTYPE_ERR_PURGE,NULL,0)

/*-------------------------------------------------------------*/
/* update configuration. Care must be taken to ensure nobody
   is currently looping through current configuration
   (lock/mutex). */
/* netwib_err f(void); */
#define netwib_global_ctl_set_conf_update() netwib_global_ctl_set(NETWIB_GLOBAL_CTLTYPE_CONF_UPDATE,NULL,0)
