/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.Serializable;
import opendap.dap.Server.InvalidParameterException;
import opendap.util.EscapeStrings;

public final class DArrayDimension
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private String name;
    private int size;
    private int start;
    private int stride;
    private int stop;

    public DArrayDimension(int size, String name) {
        this(size, name, true);
    }

    public DArrayDimension(int size, String name, boolean decodeName) {
        if (decodeName) {
            this.setName(name);
        } else {
            this.setClearName(name);
        }
        this.size = size;
        this.start = 0;
        this.stride = 1;
        this.stop = size - 1;
    }

    public Object clone() {
        try {
            DArrayDimension d = (DArrayDimension)super.clone();
            return d;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String getName() {
        return EscapeStrings.id2www(this.name);
    }

    public void setName(String name) {
        this.name = EscapeStrings.www2id(name);
    }

    public String getClearName() {
        return this.name;
    }

    public void setClearName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setProjection(int start, int stride, int stop) throws InvalidParameterException {
        String msg = "DArrayDimension.setProjection: Bad Projection Request: ";
        if (start >= this.size) {
            throw new InvalidParameterException(msg + "start (" + start + ") >= size (" + this.size + ") for " + this.name);
        }
        if (start < 0) {
            throw new InvalidParameterException(msg + "start < 0");
        }
        if (stride <= 0) {
            throw new InvalidParameterException(msg + "stride <= 0");
        }
        if (stop >= this.size) {
            throw new InvalidParameterException(msg + "stop >= size");
        }
        if (stop < 0) {
            throw new InvalidParameterException(msg + "stop < 0");
        }
        if (stop < start) {
            throw new InvalidParameterException(msg + "stop < start");
        }
        this.start = start;
        this.stride = stride;
        this.stop = stop;
        this.size = 1 + (stop - start) / stride;
    }

    public int getStart() {
        return this.start;
    }

    public int getStride() {
        return this.stride;
    }

    public int getStop() {
        return this.stop;
    }
}

