/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.DisplayException;
import visad.DisplayTupleType;
import visad.RealType;
import visad.ScalarType;
import visad.Unit;
import visad.VisADException;

public class DisplayRealType
extends RealType {
    private boolean range;
    private double LowValue;
    private double HiValue;
    private double DefaultValue;
    private DisplayTupleType tuple;
    private int tupleIndex;
    private boolean Single;
    private boolean system;
    private boolean text;
    private boolean circular;

    DisplayRealType(String name, boolean single, double def, boolean b) {
        this(name, single, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, def, null, b);
    }

    DisplayRealType(String name, boolean single, double low, double hi, double def, boolean b) {
        this(name, single, low, hi, def, null, b);
    }

    DisplayRealType(String name, boolean single, double low, double hi, double def, Unit unit, boolean b) {
        super("Display" + name, unit, b);
        this.system = true;
        this.Single = single;
        this.LowValue = low;
        this.HiValue = hi;
        this.range = !Double.isInfinite(low) && !Double.isNaN(low) && !Double.isInfinite(hi) && !Double.isNaN(hi);
        this.DefaultValue = def;
        this.tuple = null;
        this.tupleIndex = -1;
        this.text = false;
        this.circular = false;
    }

    DisplayRealType(String name, boolean single, boolean b) {
        super("Display" + name, null, b);
        this.system = true;
        this.Single = single;
        this.text = true;
        this.circular = false;
    }

    public DisplayRealType(String name, boolean single, double low, double hi, double def, Unit unit) throws VisADException {
        super("Display" + name, unit, false);
        this.system = false;
        this.Single = single;
        this.LowValue = low;
        this.HiValue = hi;
        this.range = !Double.isInfinite(low) && !Double.isNaN(low) && !Double.isInfinite(hi) && !Double.isNaN(hi);
        this.DefaultValue = def;
        this.tuple = null;
        this.tupleIndex = -1;
        this.text = false;
        this.circular = false;
    }

    public DisplayRealType(String name, boolean single, double def, Unit unit) throws VisADException {
        this(name, single, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, def, unit);
    }

    private static DisplayRealType getDisplayRealTypeByName(String name) {
        ScalarType scalarType = DisplayRealType.getScalarTypeByName(name);
        if (scalarType instanceof DisplayRealType) {
            return (DisplayRealType)scalarType;
        }
        return null;
    }

    public DisplayTupleType getTuple() {
        return this.tuple;
    }

    public int getTupleIndex() {
        return this.tupleIndex;
    }

    public void setTuple(DisplayTupleType t, int i, boolean c) throws VisADException {
        if (this.tuple != null) {
            throw new DisplayException("DisplayRealType " + this.getName() + " already has DisplayTupleType " + this.tuple);
        }
        this.tuple = t;
        this.tupleIndex = i;
        this.circular = c;
    }

    public boolean isSingle() {
        return this.Single;
    }

    public double getDefaultValue() {
        return this.DefaultValue;
    }

    public boolean getRange(double[] range_values) {
        if (this.range) {
            range_values[0] = this.LowValue;
            range_values[1] = this.HiValue;
        }
        return this.range;
    }

    public boolean getText() {
        return this.text;
    }

    public boolean getCircular() {
        return this.circular;
    }
}

