#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>

#include "slist.h"

void slist_init(struct slist* self) {
  self->next = self;
}

bool slist_null(struct slist* self) {
  return self == self->next;
}

bool slist_non_null(struct slist* self) {
  return self != self->next;
}

void slist_extend(struct slist* self, struct slist* rhs) {
  rhs->next = self->next;
  self->next = rhs;
}

size_t slist_length(struct slist* self) {
  /* XXX: Arithmetic overflow! */
  size_t result = 0;
  while (slist_non_null(self)) {
    result++;
    self = self->next;
  }
  return result;
}
